using System;
using Server;
using Server.Engines.Craft;

namespace Server.Items
{
	public class MagicalFishingPole : FishingPole
	{
		public override int BaseColdResistance{ get{ return 10; } }
		public override int BasePoisonResistance{ get{ return 5; } }

		public override int ArtifactRarity{ get{ return 15; } }
		public override int BaseStrBonus{ get{ return 10; } }
		
		private int m_Bait = 0;
		
		[CommandProperty(AccessLevel.GameMaster)]
      public int Bait { get { return m_Bait; } set { m_Bait = value; InvalidateProperties(); } }

		[Constructable]
		public MagicalFishingPole()
		{
			Name = "magical fishing pole";
			SkillBonuses.SetValues( 0, SkillName.Fishing, 10 );
			SkillBonuses.SetValues( 1, SkillName.Tracking, 10 );
			
			Attributes.BonusHits = 25;
			Attributes.Luck = 500;
			Attributes.DefendChance = 25;
		}

		public override void GetProperties( ObjectPropertyList list )
		{
         base.GetProperties( list );
         
			if ( m_Bait > 0 )
				list.Add( 1060662, "{0}\t{1}", "<basefont color=#999933>Navnada", String.Format("{0}/100<basefont color=White>", m_Bait ) );
		}

		public MagicalFishingPole( Serial serial ) : base(serial)
		{
		}

      public override void Serialize(GenericWriter writer)
      {
          base.Serialize(writer);

          writer.Write((int)1); // version
          writer.Write((int)m_Bait);
      }

      public override void Deserialize(GenericReader reader)
      {
          base.Deserialize(reader);

          int version = reader.ReadInt();

          switch (version)
          {
              case 1:
                  {
                      m_Bait = reader.ReadInt();
                      break;
                  }
          }
      }
		
		public override int OnCraft( int quality, bool makersMark, Mobile from, CraftSystem craftSystem, Type typeRes, BaseTool tool, CraftItem craftItem, int resHue )
		{
			Quality = (FishingPoleQuality)quality;

			if ( makersMark )
				Crafter = from;
				
			Type resourceType = typeRes;

			if ( resourceType == null )
				resourceType = craftItem.Ressources.GetAt( 0 ).ItemType;

			Resource = CraftResources.GetFromType( resourceType );

			CraftContext context = craftSystem.GetContext( from );

			if ( context != null && context.DoNotColor )
				Hue = 0;
				
			if ( quality == 2 )
			{
      		SkillBonuses.SetValues( 0, SkillName.Fishing, 20 );
      		SkillBonuses.SetValues( 1, SkillName.Tracking, 20 );
      		SkillBonuses.SetValues( 2, SkillName.MagicResist, 20 );
      		
      		Attributes.BonusHits = 50;
      		Attributes.Luck = 1500;
      		Attributes.DefendChance = 55;
         }

			return quality;
		}
	}
}
